datasets = ['bridge','rt1','languagetable']
methods = ['frame_ada','video_ada','lvdm']

for dataset in datasets:
    for method in methods:
        commands = []
        gpu_num = 8
        per_gpu_thread = 2
        num_thread = gpu_num * per_gpu_thread
        thread = 0
        for _ in range(per_gpu_thread):
            for rank in range(gpu_num):
                command = f"nohup python3 evaluate/generate_long_video.py --config 'configs/evaluation/{dataset}/{method}.yaml' --rank {rank} --thread {thread} --thread-num {num_thread} > {dataset}_{method}_{thread}.txt 2>&1 &"
                commands.append(command)
                commands.append('sleep 10')
                thread += 1

        commands_joined = "\n".join(commands)

        with open(f'./scripts/generate_long_video_{dataset}_{method}.sh', 'w') as file:
            print(commands_joined,file=file)

